// Table
function DataTable($container)
{
	var self = this, $rows, $columns, $all;
	
	this.rows = [];
	this.columns = [];
	this.selection = [];
	
	// Events
	this.events = {
		'listeners': {},
		
		'addListener': function(event, callback)
		{
			if(!(event in this.listeners))
			{
				this.listeners[event] = [];
			}
			
			this.listeners[event].push(callback);
		},
		
		'trigger': function(event, data)
		{
			var i;
			
			for(i=0; i<this.listeners[event].length; i++)
			{
				this.listeners[event][i].call(self, data);
			}
		}
	};
	
	// Hover
	this.events.addListener('mouseenter', function(index)
	{
		var $row = $rows.eq(index);
		
		$row.addClass('hover');
		
		$('a.checkbox', $row).addClass('hover');
	});
	
	this.events.addListener('mouseleave', function(index)
	{
		var $row = $rows.eq(index);
		
		$row.removeClass('hover');
		
		$('a.checkbox', $row).removeClass('hover');
	});
	
	// Click
	this.events.addListener('click', function(index)
	{
		var $row = $rows.eq(index);
		
		if($row.hasClass('selected'))
		{
			this.events.trigger('deselect', index);
		} else
		{
			this.events.trigger('select', index);
		}
	});
	
	// Select
	this.events.addListener('select', function(index)
	{
		var $row = $rows.eq(index);
		
		$('a.checkbox', $row.addClass('selected')).addClass('checked');
		
		if(this.selection.push(index) === this.rows.length)
		{
			$all.addClass('checked');
		}
	});
	
	// Deselect
	this.events.addListener('deselect', function(index)
	{
		var $row = $rows.eq(index);
		
		$('a.checkbox', $row.removeClass('selected')).removeClass('checked');
		
		if(this.selection.length === this.rows.length)
		{
			$all.removeClass('checked');
		}
		
		this.selection.splice(this.selection.indexOf(index), 1);
	});
	
	// Sort
	this.events.addListener('sort', function(e)
	{
		var index = this.columns.indexOf(e.column);
		/*
		$('a.sorting', $columns).removeClass('asc').removeClass('desc');
		
		$('a.sorting', $columns.eq(index)).addClass(e.asc?'asc':'desc');
		*/
	});
	
	// Draw
	this.draw = function(cols, rows, options)
	{
		var i, key, $table = $('<table/>'), $element, $label;
		
		this.rows = [];
		this.columns = [];
		this.selection = [];
		
		// Rows
		for(i=0; i<rows.length; i++)
		{
			$element = $('<tr class="row"><td class="checkbox"><a class="checkbox"/></td></tr>').appendTo($table).bind('mouseenter mouseleave click', {'index': i}, function(e)
			{
				self.events.trigger(e.type, e.data.index);
			});
			
			for(key=0; key<cols.length; key++)
			{
				rows[i][cols[key].id] = rows[i][key];
				
				if(typeof(cols[key].type) !== 'undefined')
				{
					$element.append('<td class="'+cols[key].type+'">'+rows[i][key]+'</td>');
				} else
				{
					$element.append('<td>'+rows[i][key]+'</td>');
				}
			}
			
			this.rows.push(rows[i]);
		}
		
		$rows = $('tr', $table);
		
		// Columns
		$element = $('<tr class="head"><td class="checkbox"><a class="checkbox"/></td></tr>').prependTo($table);
		
		$all = $('a.checkbox', $element).click(function()
		{
			var i;
			
			if($all.hasClass('checked'))
			{
				for(i=0; i<$rows.length; i++)
				{
					if(self.selection.indexOf(i) !== -1)
					{
						self.events.trigger('deselect', i);
					}
				}
			} else
			{
				for(i=0; i<$rows.length; i++)
				{
					if(self.selection.indexOf(i) === -1)
					{
						self.events.trigger('select', i);
					}
				}
			}
		});
		
		for(i=0; i<cols.length; i++)
		{
			$label = $('<a class="sorting"/>').bind('click', {'column': cols[i].id}, function(e)
			{
				self.events.trigger('sort',
				{
					'column': e.data.column,
					'ascending': $(this).hasClass('desc')
				});
			});
			
			if(options.sortColumn === cols[i].id)
			{
				$label.addClass(options.sortAscending?'asc':'desc');
			}
			
			if(typeof(cols[i].type) !== 'undefined')
			{
				$('<td class="'+cols[i].type+'"/>').appendTo($element).append($label.html(cols[i].label));
			} else
			{
				$('<td/>').appendTo($element).append($label.html(cols[i].label));
			}
			
			this.columns.push(cols[i].id);
		}
		
		$columns = $('td', $element);
		
		// HTML
		$container.html($table);
	};
	
	// Columns
	this.hideColumns = function(columns)
	{
		var i, index;
		
		for(i=0; i<columns.length; i++)
		{
			index = this.columns.indexOf(columns[i]) + 1; // +1 (checkbox td)
			
			$columns.eq(index).hide();
			
			$('td:eq('+(index)+')', $rows).hide();
		}
	};
}

$(function()
{
	table = new DataTable($('#table_list'));
	
	// Pagination
	var page = 0, pages;
	
	$('#prev_page').click(function()
	{
		if(page > 0)
		{
			page--;
			
			draw();
		}
	});
	
	$('#next_page').click(function()
	{
		if(page < pages - 1)
		{
			page++;
			
			draw();
		}
	});
	
	// Sorting
	table.events.addListener('sort', function(e)
	{
		page = 0;
		
		sort = e.column;
		asc = e.ascending;
		
		draw();
	});
	
	// Search
	var search = '';
	
	$('#search').submit(function(e)
	{
		e.preventDefault();
	});
	
	$('#search_input').keyup(function()
	{
		if(this.value !== search)
		{
			page = 0;
			search = this.value;
			
			draw();
		}
	});
	
	// Bulk
	var $bulk = $('#bulk a.button[class!=right]').click(function()
	{
		var i, action, instances = [];
		
		if(table.selection.length)
		{
			action = bulk[this.id.split('_')[1]];
			
			if(action[1] === false || confirm(action[1]))
			{
				for(i=0; i<table.selection.length; i++)
				{
					instances.push(table.rows[table.selection[i]].id);
				}
				
				$.ajax(action[0],
				{
					'type': 'POST',
					'data': {'instances': instances.join(',')},
					'dataType': 'json',
					'cache': false,
					'success': function(response)
					{
						var method;
						
						for(method in response)
						{
							switch(method)
							{
								case 'redraw':
									draw();
								break;
								case 'redirect':
									window.location.href = response[method];
								break;
								case 'alert':
									alert(response[method]);
								break;
							}
						}
					}
				});
			}
		}
	});
	
	table.events.addListener('select', function(e)
	{
		if(table.selection.length === 1)
		{
			$bulk.removeClass('disabled');
		}
	});
	
	table.events.addListener('deselect', function(e)
	{
		if(table.selection.length === 0)
		{
			$bulk.addClass('disabled');
		}
	});
	
	// Draw
	var xhr = false;
	
	function load_rows(response)
	{
		var view;
		
		pages = Math.ceil(response.total/pageSize);
		
		if(response.total > 0)
		{
			table.draw(cols, response.rows,
			{
				'sortColumn': sort,
				'sortAscending': asc
			});
			
			table.hideColumns(['id']);
		} else
		{
			$('#table_list').html('<p>'+lang.no_entries+'</p>');
		}
		
		// Pagination
		if(pages > 1)
		{
			$('#prev_page').show();
			$('#next_page').show();
			
			if(page === 0)
			{
				$('#prev_page').addClass('disabled');
			} else
			{
				$('#prev_page').removeClass('disabled');
			}
			
			if(page === pages - 1)
			{
				$('#next_page').addClass('disabled');
			} else
			{
				$('#next_page').removeClass('disabled');
			}
			
			$('#current_page').html(lang.current_page.replace('{current}', page+1).replace('{total}', pages)).show();
		} else
		{
			$('#prev_page').hide();
			$('#next_page').hide();
			
			$('#current_page').hide();
		}
	}
	
	function draw()
	{
		if(xhr !== false)
		{
			xhr.abort();
		}
		
		xhr = $.ajax(url.replace('{page}', page).replace('{sort}', sort).replace('{asc}', asc?1:0),
		{
			'type': 'POST',
			'data': {'search': search},
			'dataType': 'json',
			'cache': false,
			'success': load_rows
		});
	}
	
	// Initialize
	load_rows(data);
});